// OS : Windows 7
// Scilab : 5.4.1
// Toolboxes : Maxima 5.20.1 and ActivePerl 5.20.2

// Exercise 6 of Lab 7
// To find Time response parameters for the given system

clc
close

s=poly(0,'s');
g=100/(s^2+10*s)
tf=g/(1+g)

// To compare tf with Wn^2/(s^2+2*zeta*Wn+Wn^2)
y=denom(tf)
q=numer(tf)
z=coeff(y)
r=coeff(q)
wn=sqrt(r)

zeta=z(1,2)/(2*wn)
wd=(wn*sqrt(1-zeta^2))
mp=((%e^(-%pi*zeta/(sqrt(1-zeta^2))))*100)
theta=atan(sqrt(1-zeta^2)/zeta);
tr=((%pi-theta)/wd)
tp=(%pi/wd)
ts=(4/(zeta*wn))

printf("Undamped natural frequency = %f rad/sec \n",wn)
printf("Damping ratio = %f \n",zeta)
printf("Damped frequency = %f rad/sec \n",wd)
printf("Maximum Peak Overshoot = %f percent \n",mp)
printf("Theta = %f rad \n",theta)
printf("Rise time = %f sec \n",tr)
printf("Peak Time = %f sec \n",tp)
printf("Settling time = %f sec \n",ts)

